# Destinely WordPress Plugin - Version 2.5.0

## 🎯 Complete Widget Feature Alignment

### What's New in Version 2.5.0:

#### ✅ **Full Widget Feature Parity**
- **All widget configuration options** - Plugin now supports every feature available in the main widget
- **Complete data attribute support** - All widget data attributes are now properly passed
- **Perfect alignment** - Plugin matches widget functionality exactly

#### ✅ **New Configuration Options**
- **Widget Size** - Choose between small, medium, or large widget sizes
- **Max Experiences** - Control how many experiences are displayed (1-20)
- **Show/Hide Options** - Toggle prices, ratings, and duration display
- **Widget Status** - Enable or disable widget without removing plugin
- **Enhanced Customization** - Full control over widget appearance and behavior

#### ✅ **Improved Integration**
- **Perfect API alignment** - Uses same endpoints and configuration as main widget
- **Consistent behavior** - Widget behaves identically whether loaded via plugin or embed script
- **Better error handling** - Graceful fallbacks when options are not set
- **Enhanced validation** - Better validation of all configuration options

### Technical Details:

#### **New Settings**
- `destinely_widget_size` - Widget size (small/medium/large)
- `destinely_widget_max_experiences` - Maximum experiences to display
- `destinely_widget_show_prices` - Toggle price display
- `destinely_widget_show_ratings` - Toggle rating display
- `destinely_widget_show_duration` - Toggle duration display
- `destinely_widget_status` - Widget active/inactive status

#### **Data Attributes**
All widget data attributes are now properly passed:
- `data-hotel-id` - Hotel identifier
- `data-hotel-name` - Hotel name
- `data-auto-open` - Auto-open setting
- `data-notification-sound` - Sound notification
- `data-notification-message` - Message notification
- `data-position` - Widget position
- `data-color` - Widget color
- `data-title` - Widget title
- `data-trigger-delay` - Trigger delay
- `data-size` - Widget size (NEW)
- `data-show-prices` - Show prices (NEW)
- `data-show-ratings` - Show ratings (NEW)
- `data-show-duration` - Show duration (NEW)
- `data-max-experiences` - Max experiences (NEW)
- `data-status` - Widget status (NEW)

### Installation:

1. **Download** the latest plugin ZIP file (v2.5.0)
2. **Upload** to WordPress admin → Plugins → Add New → Upload Plugin
3. **Activate** the plugin
4. **Configure** all widget settings in plugin settings page
5. **Customize** widget appearance and behavior
6. **Enable** widget on booking confirmation pages

### Compatibility:

- **WordPress**: 5.0+ (tested up to 6.8)
- **PHP**: 7.4+
- **Browsers**: All modern browsers
- **Mobile**: Fully responsive design

### Support:

For technical support or questions:
- **Email**: support@destinely.com
- **Documentation**: Check plugin settings page
- **Updates**: Automatic update notifications in WordPress admin

---

**Version 2.5.0** - Complete widget feature alignment with full configuration options

---

# Destinely WordPress Plugin - Version 2.4.1

## 🐛 Bug Fixes & Improvements

### What's Fixed in Version 2.4.1:

#### ✅ **Hotel ID Validation**
- **Fixed invalid hotel ID handling** - Widget now validates hotel ID before output
- **Prevents zero UUID errors** - Blocks `00000000-0000-0000-0000-000000000000` and test IDs
- **Better error handling** - Widget won't load if hotel ID is invalid
- **Fallback hotel support** - Booking API uses fallback hotel when invalid ID detected

#### ✅ **Widget Tracking Improvements**
- **Fixed tracking errors** - Widget events now only track with valid hotel IDs
- **Zero UUID detection** - Automatically skips tracking for invalid hotel IDs
- **Better error logging** - More detailed logs for debugging tracking issues
- **Stats update fixes** - Hotel stats now update correctly with validated hotel IDs

#### ✅ **Booking Schema Compatibility**
- **Improved schema fallback** - Better handling of `confirmation_code` vs `booking_reference`
- **Enhanced error messages** - Clearer logs when schema differences are detected
- **Legacy schema support** - Maintains compatibility with older database schemas

### Technical Details:

#### **Hotel ID Validation**
- **WordPress plugin**: Validates hotel ID before outputting widget
- **API routes**: Use validated/fallback hotel ID for tracking
- **Zero UUID pattern**: `/^0{8}-0{4}-0{4}-0{4}-0{12}$/` detection
- **Fallback logic**: Uses first available hotel if original ID invalid

#### **Tracking Improvements**
- **Validation before insert**: Checks hotel ID validity before database operations
- **Graceful degradation**: Skips tracking rather than failing silently
- **Better error handling**: Uses `maybeSingle()` for safer database queries

### Installation:

1. **Download** the latest plugin ZIP file (v2.4.1)
2. **Upload** to WordPress admin → Plugins → Add New → Upload Plugin
3. **Activate** the plugin
4. **Configure** your hotel ID in plugin settings (must be valid UUID)
5. **Customize** widget title and color
6. **Enable** widget on booking confirmation pages

### Compatibility:

- **WordPress**: 5.0+ (tested up to 6.8)
- **PHP**: 7.4+
- **Browsers**: All modern browsers
- **Mobile**: Fully responsive design

### Support:

For technical support or questions:
- **Email**: support@destinely.com
- **Documentation**: Check plugin settings page
- **Updates**: Automatic update notifications in WordPress admin

---

**Version 2.4.1** - Released with hotel ID validation fixes, improved tracking, and better error handling

---

# Destinely WordPress Plugin - Version 2.4.0

## 🎨 Enhanced Widget UI/UX Update

### What's New in Version 2.4.0:

#### ✅ **Smoother Widget Animations**
- **Enhanced opening animation** with sophisticated 3-stage transition
- **Longer duration** (0.8s) for more elegant appearance
- **Staggered experience cards** with cascading effect
- **Better easing curves** for professional feel

#### ✅ **Prominent Vertical Scrollbar**
- **12px wide teal scrollbar** always visible on the right
- **Light gray track** for better contrast
- **Always shows** even with minimal content
- **Smooth scrolling** with hover effects

#### ✅ **Improved Widget Height**
- **Fixed 600px total height** (was variable)
- **500px content area** for more visible experiences
- **Better space utilization** for better UX

#### ✅ **Updated Footer Design**
- **Complete teal green background** (`#14b8a6`)
- **No white borders** - clean, professional look
- **Bold "Destinely.com" text** for better branding
- **Increased padding** for better visual balance

#### ✅ **Smart Sound Notifications**
- **Plays only on initial auto-open** (not on manual interactions)
- **One-time notification** when widget first appears
- **5-second delay** before widget appears with sound
- **Multiple fallback methods** including synthetic beep

#### ✅ **Auto-Open Timing**
- **5-second delay** before auto-open (increased from 2 seconds)
- **More user-friendly** - gives users time to explore page
- **Less intrusive** feeling - reduced "pop-up" sensation
- **Better balance** between engagement and respect

### Technical Details:

#### **Animation Improvements**
- **Widget entrance**: 3-stage slide-in with scale animation
- **Experience items**: Fade-in-up with 150ms stagger delay
- **Easing function**: `cubic-bezier(0.25, 0.46, 0.45, 0.94)`
- **Duration**: 0.8s for widget, 0.6s for experience items

#### **Scrollbar Styling**
- **Width**: 12px for better visibility
- **Color**: Teal green (`#14b8a6`) thumb with light gray track
- **Border**: 2px solid border for better definition
- **Forced display**: Always visible with `overflow-y: scroll`

#### **Sound System**
- **Auto-open only**: Sound plays once when widget automatically appears
- **Three fallback methods**: Audio ref → New audio → Synthetic beep
- **User interaction enabled**: First click enables audio context
- **Volume**: 70% for pleasant notification level

#### **Footer Enhancement**
- **Full background**: Entire footer area is teal green
- **No borders**: Removed white separation lines
- **Bold branding**: "Destinely.com" text in bold
- **Padding**: Increased from `py-2` to `py-4`

### Installation:

1. **Download** the latest plugin ZIP file
2. **Upload** to WordPress admin → Plugins → Add New → Upload Plugin
3. **Activate** the plugin
4. **Configure** your hotel ID in plugin settings
5. **Customize** widget title and color
6. **Enable** widget on booking confirmation pages

### Compatibility:

- **WordPress**: 5.0+ (tested up to 6.4)
- **PHP**: 7.4+
- **Browsers**: All modern browsers
- **Mobile**: Fully responsive design

### Support:

For technical support or questions:
- **Email**: support@destinely.com
- **Documentation**: Check plugin settings page
- **Updates**: Automatic update notifications in WordPress admin

---

**Version 2.4.0** - Released with enhanced animations, prominent scrollbar, improved height, and smart sound notifications

---

## 🚀 MVP Onboarding Flow Update

### What's New in Version 2.2.0:

#### ✅ **Simplified Hotel Onboarding**
- **"Create Hotel Account" Button** - Direct signup link in plugin settings
- **Guided Setup Process** - Clear instructions for new hotel partners
- **Zero Configuration Required** - Hotels can start immediately
- **Professional Onboarding** - Polished user experience

#### ✅ **Enhanced User Experience**
- **Clear Value Proposition** - Hotels understand what they get
- **Reduced Friction** - One-click access to registration
- **Better Instructions** - Step-by-step guidance
- **Immediate Next Steps** - Clear path to getting Hotel ID

#### ✅ **MVP-Focused Design**
- **Simple Implementation** - No complex forms or logic
- **Fast Setup** - Hotels can be live in minutes
- **Clear Call-to-Action** - Obvious next steps
- **Professional Appearance** - Builds trust and credibility

### Technical Details:

#### **Onboarding Flow**
- **Detection**: Plugin detects when no Hotel ID is provided
- **Guidance**: Shows prominent "Create Hotel Account" button
- **Redirect**: Directs to destinely.com signup page
- **Return**: Hotels return with Hotel ID to complete setup

#### **User Experience**
- **Visual Design**: Professional blue-themed callout box
- **Clear Messaging**: Explains exactly what hotels need to do
- **Action-Oriented**: Prominent button with clear text
- **Seamless Flow**: Smooth transition from plugin to platform

### Installation:

1. **Download** the latest plugin ZIP file
2. **Upload** to WordPress admin → Plugins → Add New → Upload Plugin
3. **Activate** the plugin
4. **Click** "Create Hotel Account" in plugin settings
5. **Complete** hotel registration on destinely.com
6. **Enter** your Hotel ID in plugin settings
7. **Customize** widget title and color
8. **Enable** widget on booking confirmation pages

### Compatibility:

- **WordPress**: 5.0+ (tested up to 6.4)
- **PHP**: 7.4+
- **Browsers**: All modern browsers
- **Mobile**: Fully responsive design

### Support:

For technical support or questions:
- **Email**: support@destinely.com
- **Documentation**: Check plugin settings page
- **Updates**: Automatic update notifications in WordPress admin

---

**Version 2.2.0** - Released with MVP onboarding flow and simplified hotel setup

---

# Destinely WordPress Plugin - Version 2.1.0

## 🗺️ Google Maps Integration Update

### What's New in Version 2.1.0:

#### ✅ **Google Maps Integration**
- **Real Distance Calculation** - Uses Google Maps Distance Matrix API
- **Location-Based Filtering** - Shows experiences within 50km radius
- **Smart Fallback System** - Works without API key using Haversine formula
- **Uganda Cities Database** - Pre-loaded coordinates for major cities

#### ✅ **Enhanced Data Accuracy**
- **Real Provider Data** - Shows actual business names, emails, phones
- **Real Category Data** - Displays actual category names and colors
- **Real Experience Data** - All titles, descriptions, prices from database
- **Real Meeting Points** - Actual meeting locations from providers

#### ✅ **Improved Performance**
- **Optimized Queries** - Simplified database queries for better performance
- **Error Handling** - Graceful fallbacks when services are unavailable
- **Caching** - Better caching for faster loading

#### ✅ **Better Integration**
- **Unified API** - Same data source as main Destinely widget
- **Consistent Experience** - Identical functionality across platforms
- **Real-time Updates** - Live data synchronization

### Technical Details:

#### **Google Maps API (Optional)**
- **Free Tier**: $200 monthly credit (covers ~28,000 requests)
- **Required APIs**: Geocoding + Distance Matrix
- **Fallback**: Works without API key using built-in city coordinates

#### **Distance Calculation**
- **Real Distances**: Road distances via Google Maps API
- **Fallback Distances**: Haversine formula for straight-line distances
- **Radius Filtering**: 50km default radius (configurable)

#### **Data Sources**
- **Experiences**: Real approved experiences from Supabase
- **Providers**: Actual business information from database
- **Categories**: Real category names and colors
- **Locations**: Geocoded addresses or city coordinates

### Installation:

1. **Download** the latest plugin ZIP file
2. **Upload** to WordPress admin → Plugins → Add New → Upload Plugin
3. **Activate** the plugin
4. **Configure** your hotel ID in plugin settings
5. **Optional**: Add Google Maps API key for enhanced distance calculation

### Compatibility:

- **WordPress**: 5.0+ (tested up to 6.4)
- **PHP**: 7.4+
- **Browsers**: All modern browsers
- **Mobile**: Fully responsive design

### Support:

For technical support or questions:
- **Email**: support@destinely.com
- **Documentation**: Check plugin settings page
- **Updates**: Automatic update notifications in WordPress admin

---

**Version 2.1.0** - Released with Google Maps integration and enhanced data accuracy
