# Destinely Widget - Image Management Guide

## Overview

The Destinely WordPress plugin now supports a **6-image carousel** for each experience (providers can upload up to 8 images), allowing hotel guests to see multiple photos of each activity before booking.

## How Images Work

### 1. **Image Sources**
Images for experiences come from the main Destinely platform where experience providers upload them. The plugin automatically fetches these images and displays them in a carousel.

### 2. **Carousel Features**
- **6 Images Maximum**: Each experience can display up to 6 images in the widget
- **8 Images Upload**: Providers can upload up to 8 images per experience
- **Navigation Arrows**: Left/right arrows appear on hover
- **Dot Indicators**: Small dots at the bottom show current image position
- **Smooth Transitions**: Fade transitions between images
- **Mobile Optimized**: Touch-friendly on mobile devices

### 3. **Image Display Logic**
The plugin handles images in this priority order:
1. **Multiple Images**: If the experience has an `images` array, it uses those
2. **Single Image**: If only `image_url` is available, it converts to an array
3. **Placeholder**: If no images are available, shows a default placeholder

## For Experience Providers

### Uploading Images
1. **Log into your Destinely provider dashboard**
2. **Go to "My Experiences"**
3. **Edit an experience**
4. **Upload up to 8 high-quality images** (recommended: 1200x800px)
5. **Save the experience**
6. **Note**: Widget will display the first 6 images in the carousel

### Image Requirements
- **Format**: JPG, PNG, or WebP
- **Size**: Maximum 10MB per image
- **Dimensions**: Recommended 1200x800px (16:9 ratio)
- **Quality**: High-quality, well-lit photos that showcase the experience

### Best Practices
- **Image 1**: Main activity shot (most important - will be shown first)
- **Image 2**: Location/venue shot
- **Image 3**: People enjoying the experience
- **Images 4-6**: Additional details, different angles, or highlights (shown in widget)
- **Images 7-8**: Extra images for full experience page (optional)

## For Hotel Administrators

### No Action Required
- Images are automatically managed by the Destinely platform
- The widget will display images as soon as providers upload them
- No manual image management needed on your WordPress site

### Customization Options
In the WordPress plugin settings, you can customize:
- **Widget appearance** (colors, position, etc.)
- **Number of experiences shown**
- **Display options** (prices, ratings, etc.)

## Technical Details

### API Integration
The plugin fetches experience data including images from:
```
GET /api/widget/config/{hotel_id}
```

### Image Processing
- Images are automatically filtered for valid URLs
- Maximum of 8 images can be uploaded per experience
- Widget displays up to 6 images per experience in carousel
- Fallback to placeholder if images fail to load
- Responsive sizing for all devices

### Performance
- Images are served from CDN for fast loading
- Lazy loading for better performance
- Optimized for mobile networks

## Troubleshooting

### Images Not Showing
1. **Check experience approval**: Only approved experiences show images
2. **Verify provider uploads**: Ensure providers have uploaded images
3. **Check network**: Ensure your site can access external image URLs
4. **Clear cache**: Clear WordPress cache if using caching plugins

### Carousel Not Working
1. **JavaScript enabled**: Ensure JavaScript is enabled in browser
2. **Plugin version**: Update to latest plugin version
3. **Theme conflicts**: Test with default WordPress theme
4. **Console errors**: Check browser console for JavaScript errors

### Mobile Issues
1. **Touch events**: Ensure touch events are not blocked
2. **Viewport**: Check if viewport meta tag is present
3. **CSS conflicts**: Test with minimal CSS

## Support

For image-related issues:
- **Provider issues**: Contact Destinely support
- **Plugin issues**: Check plugin documentation
- **WordPress issues**: Contact your WordPress developer

## Future Enhancements

Planned features:
- **Image lazy loading** for better performance
- **Custom image captions** for accessibility
- **Image zoom functionality** on click
- **Video support** for experiences
- **360° panorama support** for locations 