<?php
/**
 * Uninstall file for Destinely Experiences Widget
 * 
 * This file is executed when the plugin is deleted from WordPress.
 * It cleans up all plugin data including options and database tables.
 *
 * @package DestinelyExperiencesWidget
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options
delete_option('destinely_hotel_id');
delete_option('destinely_hotel_name');
delete_option('destinely_widget_enabled');
delete_option('destinely_widget_auto_open');
delete_option('destinely_widget_sound');
delete_option('destinely_widget_notification');
delete_option('destinely_widget_position');
delete_option('destinely_widget_trigger_delay');
delete_option('destinely_widget_color');
delete_option('destinely_widget_title');

// Delete site options (for multisite)
delete_site_option('destinely_hotel_id');
delete_site_option('destinely_hotel_name');
delete_site_option('destinely_widget_enabled');
delete_site_option('destinely_widget_auto_open');
delete_site_option('destinely_widget_sound');
delete_site_option('destinely_widget_notification');
delete_site_option('destinely_widget_position');
delete_site_option('destinely_widget_trigger_delay');
delete_site_option('destinely_widget_color');
delete_site_option('destinely_widget_title');

// Drop custom database tables if they exist
global $wpdb;

$table_name = $wpdb->prefix . 'destinely_analytics';
$wpdb->query("DROP TABLE IF EXISTS {$table_name}");

// Clear any cached data
wp_cache_flush();

